<?php

namespace App\Livewire\User\Withdrawal;

use App\Models\PaymentMethod;
use App\Models\Settings;
use Livewire\Attributes\On;
use Livewire\Component;
use Illuminate\Support\Facades\Session;

class ChooseWithdrawMethod extends Component
{
    public $request = false;
    public $selectedMethod = null;
    public ?PaymentMethod $method = null;

    public function render()
    {
        $template = Settings::select('theme')->find(1)->theme;
        
        return view("{$template}.withdrawal.choose-withdraw-method", [
            'methods' => PaymentMethod::where(function ($query) {
                $query->where('type', 'withdrawal')
                    ->orWhere('type', 'both');
            })->where('status', 'active')->latest()->get(),
        ])
            ->extends("layouts.{$template}")
            ->title('Withdrawal request');
    }

    #[On('complete_withdrawal')]
    public function cancel(): void
    {
        $this->request = false;
        $this->selectedMethod = null;
        $this->method = null;
    }

    public function requestWithdrawal(string $id): void
    {
        if (!auth()->user()->can_withdraw) {
            Session::flash('message', __('t.withdrawal_not_allowed'));
            Session::flash('alert', 'error');
            return;
        }

        $this->method = PaymentMethod::findOrFail($id);
        $this->request = true;
    }

    // New method to handle dropdown selection
    public function updatedSelectedMethod($value): void
    {
        if ($value) {
            $this->method = PaymentMethod::findOrFail($value);
        } else {
            $this->method = null;
        }
    }

    // Reset state when component is mounted
    public function mount(): void
    {
        $this->request = false;
        $this->selectedMethod = null;
        $this->method = null;
    }
}