@props([
    'title' => __('Confirm Password'),
    'content' => __('For your security, please confirm your password to continue.'),
    'button' => __('Confirm'),
])

@php
    $confirmableId = md5($attributes->wire('then'));
@endphp

<span 
    {{ $attributes->wire('then') }} 
    x-data 
    x-ref="span"
    x-on:click="$wire.startConfirmingPassword('{{ $confirmableId }}')"
    x-on:password-confirmed.window="setTimeout(() => $event.detail.id === '{{ $confirmableId }}' && $refs.span.dispatchEvent(new CustomEvent('then', { bubbles: false })), 250)"
>
    {{ $slot }}
</span>

@once
    <x-dialog-modal wire:model.live="confirmingPassword" max-width="lg">
        <x-slot name="title">
            {{ $title }}
        </x-slot>

        <x-slot name="content">
            {{ $content }}

            <div class="mt-4" 
                 x-data="{}"
                 x-on:confirming-password.window="setTimeout(() => $refs.confirmable_password.focus(), 250)">
                <div class="relative">
                    <input 
                        type="password"
                        class="w-full bg-theme-tertiary border-0 rounded-xl px-4 py-3 text-gray-200 placeholder-gray-500 focus:ring-2 focus:ring-theme-primary"
                        placeholder="{{ __('Password') }}"
                        autocomplete="current-password"
                        x-ref="confirmable_password"
                        wire:model="confirmablePassword"
                        wire:keydown.enter="confirmPassword" 
                    />
                    <div wire:loading class="absolute right-3 top-1/2 -translate-y-1/2">
                        <i data-lucide="loader-2" class="w-5 h-5 animate-spin text-gray-400"></i>
                    </div>
                </div>
                @error('confirmable_password')
                    <span class="mt-2 text-sm text-red-400">{{ $message }}</span>
                @enderror
            </div>
        </x-slot>

        <x-slot name="footer">
            <button 
                type="button"
                wire:click="stopConfirmingPassword"
                wire:loading.attr="disabled"
                class="inline-flex items-center px-4 py-2 bg-gray-800/50 text-gray-300 rounded-lg hover:bg-gray-800 transition-colors"
            >
                {{ __('Cancel') }}
            </button>

            <button 
                type="button"
                wire:click="confirmPassword"
                wire:loading.attr="disabled"
                class="inline-flex items-center px-4 py-2 bg-theme-primary text-white rounded-lg hover:bg-[#1D4ED8] transition-colors"
                dusk="confirm-password-button"
            >
                <span wire:loading.remove wire:target="confirmPassword">
                    {{ $button }}
                </span>
                <span wire:loading wire:target="confirmPassword">
                    <i data-lucide="loader-2" class="w-5 h-5 animate-spin"></i>
                </span>
            </button>
        </x-slot>
    </x-dialog-modal>
@endonce





