<div class="space-y-6">
    {{-- Breadcrumbs --}}
    <div class="flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-gray-100">Dashboard</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <a href="{{ route('user.copier.show') }}" @if($settings->spa_mode) wire:navigate @endif class="text-gray-400 hover:text-gray-100">Copytrade overview</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">Providers</span>
    </div>

    <x-danger-alert />
    <x-success-alert />

    {{-- Providers Grid --}}
    <div class="grid gap-6 md:grid-cols-2 lg:grid-cols-3">
        @forelse($providers as $provider)
            <div class="bg-theme-secondary rounded-xl">
                <div class="p-6">
                    {{-- Status Badge --}}
                    <div class="flex justify-between items-center">
                        <span @class([
                            'px-2 py-1 text-xs rounded-full',
                            'bg-theme-primary/10 text-theme-primary' => Str::upper($provider['deployment_status']) === 'DEPLOYED',
                            'bg-red-400/10 text-red-400' => Str::upper($provider['deployment_status']) === 'UNDEPLOYED',
                        ])>
                            {{ $provider['deployment_status'] }}
                        </span>
                        <div wire:loading>
                            <i data-lucide="loader-2" class="w-4 h-4 animate-spin"></i>
                        </div>
                    </div>

                    {{-- Provider Details --}}
                    <div class="mt-6 space-y-3">
                        <div class="flex justify-between bg-gray-800/50 p-3 rounded-lg">
                            <span class="text-gray-400 flex items-center gap-2">
                                <i data-lucide="user" class="w-4 h-4"></i>
                                Name:
                            </span>
                            <span class="font-medium">{{ $provider['account_name'] }}</span>
                        </div>

                        <div class="flex justify-between bg-gray-800/50 p-3 rounded-lg">
                            <span class="text-gray-400 flex items-center gap-2">
                                <i data-lucide="log-in" class="w-4 h-4"></i>
                                Login:
                            </span>
                            <span class="font-medium">{{ $provider['login'] }}</span>
                        </div>

                        <div class="flex justify-between bg-gray-800/50 p-3 rounded-lg">
                            <span class="text-gray-400 flex items-center gap-2">
                                <i data-lucide="layers" class="w-4 h-4"></i>
                                Platform:
                            </span>
                            <span class="font-medium">{{ Str::upper($provider['platform'] ?? '') }}</span>
                        </div>

                        <div class="flex justify-between bg-gray-800/50 p-3 rounded-lg">
                            <span class="text-gray-400 flex items-center gap-2">
                                <i data-lucide="server" class="w-4 h-4"></i>
                                Server:
                            </span>
                            <span class="font-medium">{{ $provider['server'] }}</span>
                        </div>

                        <div class="flex justify-between bg-gray-800/50 p-3 rounded-lg">
                            <span class="text-gray-400 flex items-center gap-2">
                                <i data-lucide="landmark" class="w-4 h-4"></i>
                                Currency:
                            </span>
                            <span class="font-medium">{{ $provider['currency'] }}</span>
                        </div>

                        <div class="flex justify-between bg-gray-800/50 p-3 rounded-lg">
                            <span class="text-gray-400 flex items-center gap-2">
                                <i data-lucide="percent" class="w-4 h-4"></i>
                                Leverage:
                            </span>
                            <span class="font-medium">{{ $provider['leverage'] }}</span>
                        </div>
                    </div>
                </div>

                {{-- Footer --}}
                <div class="p-6 border-t border-gray-800">
                    <a href="{{ route('user.copier.master.details', ['login' => $provider['login']]) }}"
                        @if($settings->spa_mode) wire:navigate @endif
                        class="inline-flex items-center gap-2 text-theme-primary hover:text-theme-primary-dark transition-colors">
                        <span>View provider information</span>
                        <i data-lucide="arrow-right" class="w-4 h-4"></i>
                    </a>
                </div>
            </div>
        @empty
            <div class="md:col-span-2 lg:col-span-3">
                <div class="bg-theme-secondary rounded-xl p-12 text-center">
                    <div class="w-16 h-16 bg-gray-800/50 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i data-lucide="users" class="w-8 h-8 text-gray-400"></i>
                    </div>
                    <h5 class="text-lg font-medium mb-4">{{ __('No providers found.') }}</h5>
                    <a href="{{ route('user.copier.show') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        class="inline-flex items-center gap-2 bg-theme-primary text-black px-4 py-2 rounded-lg hover:bg-theme-primary-dark transition-colors">
                        <i data-lucide="arrow-left" class="w-4 h-4"></i>
                        <span>Go back</span>
                    </a>
                </div>
            </div>
        @endforelse
    </div>
</div>

<script>
    lucide.createIcons();
</script>



