<div class="space-y-6 mb-5 md:mb-1">
    {{-- Breadcrumbs 
    <div class="pl-3 pt-3 flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-theme-primary">{{ __('t.dashboard') }}</a>
        <i class="fas fa-chevron-right w-4 h-4 mx-2 text-gray-400"></i>
        <a href="{{ route('user.swap.assets') }}" class="text-gray-400 hover:text-theme-primary">{{ __('t.assets') }}</a>
        <i class="fas fa-chevron-right w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">{{ __('t.swap') }}</span>
    </div> --}}

    <x-danger-alert />
    <x-success-alert />

    <div class="max-w-xl mx-auto">
        <div class="bg-theme-secondary rounded-2xl">
            {{-- Header --}}
            <div class="border-b border-gray-800/50 p-6">
                <h2 class="text-lg font-medium flex items-center gap-3">
                    <i class="fas fa-exchange-alt text-theme-primary"></i>
                    {{ __('t.swap_crypto') }}
                </h2>
            </div>

            <form wire:submit='convert' wire:confirm='{{ __("t.are_you_sure_swap") }}' class="p-6">
                {{-- From Section --}}
                <div class="bg-theme-tertiary rounded-xl p-4 mb-4">
                    <div class="flex justify-between items-center mb-4">
                        <label class="text-sm text-gray-400">{{ __('t.you_pay') }}</label>
                        <span class="text-sm text-gray-400">
                            {{ __('t.balance') }}: 
                            <span class="text-gray-300">
                                @if($from_is_account_balance)
                                    {{ Number::currency($from_balance, $settings->s_currency) }}
                                @else
                                    {{ $from_balance }} {{ $from_currency->symbol }}
                                @endif
                            </span>
                        </span>
                    </div>
                    <div class="flex items-center gap-4">
                        <div x-data="{ open: false }" class="relative">
                            <button type="button" 
                                @click="open = !open"
                                class="min-w-[160px] h-14 px-4 bg-theme-quaternary rounded-xl flex items-center justify-between gap-2 hover:bg-[#3A344B] transition-all group">
                                <div class="flex items-center gap-3">
                                    @if($from_is_account_balance)
                                        <div class="w-8 h-8 bg-theme-primary/10 rounded-lg flex items-center justify-center">
                                            <i class="fas fa-wallet text-theme-primary"></i>
                                        </div>
                                        <span>{{ __('t.account_balance_short') }}</span>
                                    @else
                                        <img src="{{ $from_currency->logo_url }}" class="w-8 h-8 rounded-lg" alt="{{ $from_currency->symbol }}">
                                        <div class="text-left">
                                            <span class="block">{{ $from_currency->symbol }}</span>
                                            <span class="text-xs text-gray-400">{{ $from_currency->name }}</span>
                                        </div>
                                    @endif
                                </div>
                                <i class="fas fa-chevron-down text-gray-400"></i>
                            </button>

                            {{-- Dropdown Menu --}}
                            <div x-show="open" 
                                @click.away="open = false"
                                x-transition
                                class="absolute left-0 mt-2 w-72 max-h-72 overflow-y-auto bg-theme-quaternary rounded-xl border border-gray-800/50 shadow-xl z-50"
                                style="display: none;">
                                <div class="p-2 space-y-1">
                                    <button type="button"
                                        wire:click="selectFromAsset('{{ __('t.account_balance') }}')"
                                        @click="open = false"
                                        class="w-full p-3 text-left hover:bg-[#3A344B] rounded-lg transition-colors flex items-center gap-3"
                                        :class="{ 'bg-[#3A344B]': {{ $from_is_account_balance ? 'true' : 'false' }} }">
                                        <div class="w-8 h-8 bg-theme-primary/10 rounded-lg flex items-center justify-center">
                                            <i class="fas fa-wallet text-theme-primary"></i>
                                        </div>
                                        <span>{{ __('t.account_balance') }}</span>
                                    </button>
                                    
                                    @foreach($assets as $asset)
                                        <button type="button"
                                            wire:click="selectFromAsset('{{ $asset['asset']->symbol }}')"
                                            @click="open = false"
                                            class="w-full p-3 text-left hover:bg-[#3A344B] rounded-lg transition-colors flex items-center gap-3"
                                            :class="{ 'bg-[#3A344B]': {{ $symbol == $asset['asset']->symbol ? 'true' : 'false' }} }">
                                            <img src="{{ $asset['asset']->logo_url }}" class="w-8 h-8 rounded-lg" alt="{{ $asset['asset']->symbol }}">
                                            <div>
                                                <p class="font-medium">{{ $asset['asset']->symbol }}</p>
                                                <p class="text-xs text-gray-400">{{ $asset['asset']->name }}</p>
                                            </div>
                                        </button>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                       <div class="flex-1">
                            <div class="space-y-2">
                                {{-- Input Field --}}
                                <input type="number" 
                                    wire:model.live='from_amount'
                                    wire:keyup='calculate'
                                    step="any"
                                    class="w-full bg-theme-quaternary px-4 py-3 sm:py-4 text-lg sm:text-xl font-medium rounded-xl focus:outline-none focus:ring-2 focus:ring-theme-primary/50 text-right"
                                    required
                                    placeholder="0.00"
                                >
                                {{-- Mobile-friendly Percentage Selector --}}
                                <div class="grid grid-cols-4 gap-1.5">
                                    @foreach([5, 15, 50, 100] as $percentage)
                                        <button type="button" 
                                            wire:click="setPercentageAmount({{ $percentage }})"
                                            class="py-1.5 px-2 text-[11px] sm:text-xs font-medium rounded-lg transition-all bg-theme-quaternary text-gray-400 hover:bg-[#3A344B] hover:text-gray-300">
                                            {{ $percentage === 100 ? __('t.max') : $percentage . '%' }}
                                        </button>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Swap Button --}}
                <div class="flex justify-center -my-2 relative z-10">
                    <button type="button" 
                        wire:click="switchAssets" 
                        class="w-10 h-10 bg-theme-quaternary rounded-xl flex items-center justify-center hover:bg-[#3A344B] transition-all hover:scale-110 group">
                        <i class="fas fa-exchange-alt text-theme-primary rotate-90 group-hover:rotate-180 transition-transform duration-300"></i>
                    </button>
                </div>

                {{-- To Section --}}
                <div class="bg-theme-tertiary rounded-xl p-4 mb-6">
                    <div class="flex justify-between items-center mb-4">
                        <label class="text-sm text-gray-400">{{ __('t.you_receive') }}</label>
                        <span class="text-sm text-gray-400">
                            {{ __('t.balance') }}: 
                            <span class="text-gray-300">
                                @if($to_is_account_balance)
                                    {{ Number::currency($to_balance, $settings->s_currency) }}
                                @else
                                    {{ $to_balance }} {{ $to_currency->symbol }}
                                @endif
                            </span>
                        </span>
                    </div>
                    <div class="flex items-center gap-4">
                        <div x-data="{ open: false }" class="relative">
                            <button type="button" 
                                @click="open = !open"
                                class="min-w-[160px] h-14 px-4 bg-theme-quaternary rounded-xl flex items-center justify-between gap-2 hover:bg-[#3A344B] transition-all group">
                                <div class="flex items-center gap-3">
                                    @if($to_is_account_balance)
                                        <div class="w-8 h-8 bg-theme-primary/10 rounded-lg flex items-center justify-center">
                                            <i class="fas fa-wallet text-theme-primary"></i>
                                        </div>
                                        <span>{{ __('t.account_balance_short') }}</span>
                                    @else
                                        <img src="{{ $to_currency->logo_url }}" class="w-8 h-8 rounded-lg" alt="{{ $to_currency->symbol }}">
                                        <div class="text-left">
                                            <span class="block">{{ $to_currency->symbol }}</span>
                                            <span class="text-xs text-gray-400">{{ $to_currency->name }}</span>
                                        </div>
                                    @endif
                                </div>
                                <i class="fas fa-chevron-down text-gray-400"></i>
                            </button>

                            {{-- Dropdown Menu --}}
                            <div x-show="open" 
                                @click.away="open = false"
                                x-transition
                                class="absolute left-0 mt-2 w-72 max-h-72 overflow-y-auto bg-theme-quaternary rounded-xl border border-gray-800/50 shadow-xl z-[100]"
                                style="display: none;">
                                <div class="p-2 space-y-1">
                                    <button type="button"
                                        wire:click="selectToAsset('{{ __('t.account_balance') }}')"
                                        @click="open = false"
                                        class="w-full p-3 text-left hover:bg-[#3A344B] rounded-lg transition-colors flex items-center gap-3"
                                        :class="{ 'bg-[#3A344B]': {{ $to_is_account_balance ? 'true' : 'false' }} }">
                                        <div class="w-8 h-8 bg-theme-primary/10 rounded-lg flex items-center justify-center">
                                            <i class="fas fa-wallet text-theme-primary"></i>
                                        </div>
                                        <span>{{ __('t.account_balance') }}</span>
                                    </button>
                                    
                                    @foreach($assets as $asset)
                                        <button type="button"
                                            wire:click="selectToAsset('{{ $asset['asset']->symbol }}')"
                                            @click="open = false"
                                            class="w-full p-3 text-left hover:bg-[#3A344B] rounded-lg transition-colors flex items-center gap-3"
                                            :class="{ 'bg-[#3A344B]': {{ $symbol == $asset['asset']->symbol ? 'true' : 'false' }} }">
                                            <img src="{{ $asset['asset']->logo_url }}" class="w-8 h-8 rounded-lg" alt="{{ $asset['asset']->symbol }}">
                                            <div>
                                                <p class="font-medium">{{ $asset['asset']->symbol }}</p>
                                                <p class="text-xs text-gray-400">{{ $asset['asset']->name }}</p>
                                            </div>
                                        </button>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        <div class="flex-1">
                            <input type="number" 
                                wire:model.live='to_amount'
                                readonly
                                class="w-full bg-theme-quaternary px-4 py-4 text-xl font-medium rounded-xl focus:outline-none text-right"
                                placeholder="0.00"
                            >
                        </div>
                    </div>
                </div>

                {{-- Rate Info --}}
                <div class="bg-theme-tertiary rounded-xl p-4 space-y-3 mb-6">
                    <div class="flex justify-between items-center text-sm">
                        <span class="text-gray-400">{{ __('t.exchange_rate') }}</span>
                        <span class="font-medium">
                            @if($from_amount && $to_amount)
                                1 {{ $from_is_account_balance ? $settings->s_currency : $from_currency->symbol }} ≈ 
                                {{ $to_is_account_balance ? Number::currency($to_amount/$from_amount, $settings->s_currency) : number_format($to_amount/$from_amount, 8) }} 
                                {{ $to_is_account_balance ? '' : $to_currency->symbol }}
                            @else
                                -
                            @endif
                        </span>
                    </div>
                    <div class="flex justify-between items-center text-sm">
                        <span class="text-gray-400">{{ __('t.network_fee') }}</span>
                        <span class="text-theme-primary font-medium">{{ $settings->swap_fee }}%</span>
                    </div>
                </div>

                {{-- Submit Button --}}
                <button type="submit" 
                    class="w-full bg-gradient-theme-primary text-black font-medium px-6 py-4 rounded-xl hover:brightness-110 transition-all flex items-center justify-center gap-3">
                    <div wire:loading wire:target="convert">
                        <i class="fas fa-spinner fa-spin"></i>
                    </div>
                    <span wire:loading.remove wire:target="convert">{{ __('t.confirm_swap') }}</span>
                    <span wire:loading wire:target="convert">{{ __('t.processing') }}</span>
                </button>
            </form>
        </div>
    </div>
</div>



