<div class="px-2 space-y-6 mb-5 md:mb-1">
    {{-- Header Section 
    <div class="pl-3 pt-3 flex items-center justify-between">
        <div>
            <div class="flex items-center text-sm text-gray-400">
                <a href="{{ route('user.dashboard') }}" class="hover:text-theme-primary">{{ __('t.dashboard') }}</a>
                <i data-lucide="chevron-right" class="w-4 h-4 mx-2"></i>
                <span>{{ __('t.swap_history') }}</span>
            </div>
        </div>
    </div> --}}
    
    <x-danger-alert />
    <x-success-alert />

    {{-- Transaction List --}}
    <div class="bg-theme-secondary rounded-2xl p-6 space-y-4">
        @forelse($transactions as $tran)
            <div class="bg-theme-tertiary rounded-xl p-4 hover:bg-theme-quaternary transition-colors">
                <div class="flex flex-col md:flex-row justify-between gap-6">
                    {{-- Swap Details --}}
                    <div class="flex items-center gap-4">
                        <div class="bg-theme-primary/10 p-3 rounded-xl">
                            <i class="fas fa-sync-alt" style="font-size: 1.5rem; color: #2563EB;"></i>
                        </div>
                        <div>
                            <div class="flex items-center gap-2 mb-1">
                                <span class="text-sm text-gray-400">{{ __('t.from') }}</span>
                                <span class="font-medium">{{ $tran->source }}</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <span class="text-sm text-gray-400">{{ __('t.to') }}</span>
                                <span class="font-medium">{{ $tran->dest }}</span>
                            </div>
                        </div>
                    </div>

                    {{-- Amount Details --}}
                    <div class="flex items-center gap-8">
                        <div>
                            <div class="text-sm text-gray-400 mb-1">{{ __('t.amount') }}</div>
                            <div class="text-lg font-medium">
                                @if($tran->source == __('t.account_balance'))
                                    {{ Number::currency(floatval($tran->amount), $settings->s_currency) }}
                                @else
                                    {{ round(floatval($tran->amount), 8) }} 
                                    <span class="text-sm text-gray-400">{{ $tran->source }}</span>
                                @endif
                            </div>
                        </div>
                        <div>
                            <div class="text-sm text-gray-400 mb-1">{{ __('t.received') }}</div>
                            <div class="text-lg font-medium text-theme-primary">
                                @if($tran->dest == __('t.account_balance'))
                                    {{ Number::currency(floatval($tran->quantity), $settings->s_currency) }}
                                @else
                                    {{ round(floatval($tran->quantity), 8) }}
                                    <span class="text-sm">{{ $tran->dest }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="hidden md:block">
                            <div class="text-sm text-gray-400 mb-1">{{ __('t.date') }}</div>
                            <div>{{ $tran->created_at->format('M d, Y h:i A') }}</div>
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="py-12 text-center">
                <div class="bg-theme-tertiary w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-4">
                    <i data-lucide="arrows-right-left" class="w-8 h-8 text-gray-400"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-400">{{ __('t.no_swaps_yet') }}</h3>
                <p class="text-gray-500 text-sm mt-1">{{ __('t.swap_history_empty_message') }}</p>
            </div>
        @endforelse

        {{-- Pagination --}}
        <div class="mt-6">
            {{ $transactions->links() }}
        </div>
    </div>
</div>



