<div id="mobileSidebar" class="fixed inset-0 bg-black/60 backdrop-blur-sm z-50 md:hidden hidden">
    <div class="absolute left-0 top-0 bottom-0 w-80 bg-theme-secondary shadow-xl overflow-hidden">
        
        <button id="closeMobileSidebar" 
            class="absolute top-4 right-4 w-8 h-8 flex items-center justify-center rounded-full bg-gray-800/50 text-gray-400 hover:text-theme-primary transition-colors">
            <i class="fas fa-times"></i>
        </button>

        
        <div class="flex flex-col h-full">
            
            <div class="p-6 border-b border-gray-800/50">
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 rounded-xl bg-theme-tertiary flex-shrink-0 overflow-hidden">
                        <img 
                            src="<?php echo e(auth()->user()->profile_photo_path ? asset('storage/' . auth()->user()->profile_photo_path) : asset('dash/images/avatar.svg')); ?>"
                            alt="<?php echo e(auth()->user()->name); ?>"
                            class="w-full h-full object-cover">
                    </div>
                    <div class="flex-1 min-w-0">
                        <h3 class="font-medium truncate"><?php echo e(auth()->user()->name); ?></h3>
                        <p class="text-sm text-gray-400 truncate"><?php echo e(auth()->user()->email); ?></p>
                    </div>
                </div>
            </div>

            
            <div class="flex-1 overflow-y-auto">
                <div class="p-4">
                    <nav class="space-y-1">
                        
                        <div class="mb-6">
                            <a href="<?php echo e(route('user.dashboard')); ?>" 
                                <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                                    'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.dashboard'),
                                    'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.dashboard')
                                ]); ?>">
                                <i class="fas fa-th-large w-5 h-5"></i>
                                <span>Dashboard</span>
                            </a>
                        </div>

                        
                        <div class="mb-6">
                            <p class="px-4 py-2 text-xs font-medium text-gray-400 uppercase mb-2">Trading</p>

                            
                            <a href="<?php echo e(route('user.trading.overview')); ?>" 
                                <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                                    'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.trading.*'),
                                    'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.trading.*')
                                ]); ?>">
                                <i class="fas fa-chart-candlestick w-5 h-5"></i>
                                <span>Live Trading</span>
                                <span class="ml-auto bg-theme-primary/20 text-theme-primary text-xs px-2 py-0.5 rounded-full font-semibold">NEW</span>
                            </a>

                            
                            <?php if($mod['cryptoswap'] == 'true'): ?>
                            <div x-data="{ open: <?php echo e(request()->routeIs('user.swap.*') ? 'true' : 'false'); ?> }">
                                <button @click="open = !open" 
                                    class="flex items-center justify-between w-full px-4 py-2.5 rounded-xl transition-all"
                                    :class="{'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary': open, 'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100': !open}">
                                    <div class="flex items-center gap-3">
                                        <i class="fas fa-repeat w-5 h-5"></i>
                                        <span>Crypto Swap</span>
                                    </div>
                                    <i class="fas fa-chevron-down w-4 h-4 transition-transform" :class="open ? 'rotate-180' : ''"></i>
                                </button>
                                <div x-show="open"
                                    x-transition:enter="transition ease-out duration-200"
                                    x-transition:enter-start="opacity-0 -translate-y-2"
                                    x-transition:enter-end="opacity-100 translate-y-0"
                                    class="pl-12 mt-1 space-y-1">
                                    <a href="<?php echo e(route('user.swap.assets')); ?>" 
                                        <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                        class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                            'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                            'text-theme-primary' => request()->routeIs('user.swap.assets'),
                                            'text-gray-400 hover:text-gray-100' => !request()->routeIs('user.swap.assets')
                                        ]); ?>">
                                        Market Assets
                                    </a>
                                    <a href="<?php echo e(route('user.swap.transactions')); ?>" 
                                        <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                        class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                            'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                            'text-theme-primary' => request()->routeIs('user.swap.transactions'),
                                            'text-gray-400 hover:text-gray-100' => !request()->routeIs('user.swap.transactions')
                                        ]); ?>">
                                        Swap History
                                    </a>
                                </div>
                            </div>
                            <?php endif; ?>

                            
                            <?php if($settings->use_copytrade): ?>
                            <a href="<?php echo e(route('user.copier.show')); ?>" 
                                <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                                    'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.copier.*'),
                                    'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.copier.*')
                                ]); ?>">
                                <i class="fas fa-copy w-5 h-5"></i>
                                <span>Copy Trading</span>
                            </a>
                            <?php endif; ?>

                            
                          
                        </div>

                        
                        <?php if($mod['investment'] == 'true'): ?>
                        <div class="mb-6">
                            <p class="px-4 py-2 text-xs font-medium text-gray-400 uppercase mb-2">Investment</p>
                            
                            <div x-data="{ open: <?php echo e(request()->routeIs('user.investment.*') ? 'true' : 'false'); ?> }">
                                <button @click="open = !open" 
                                    class="flex items-center justify-between w-full px-4 py-2.5 rounded-xl transition-all"
                                    :class="{'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary': open, 'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100': !open}">
                                    <div class="flex items-center gap-3">
                                        <i class="fas fa-chart-line w-5 h-5"></i>
                                        <span>Investment Plans</span>
                                    </div>
                                    <i class="fas fa-chevron-down w-4 h-4 transition-transform" :class="open ? 'rotate-180' : ''"></i>
                                </button>
                                <div x-show="open"
                                    x-transition:enter="transition ease-out duration-200"
                                    x-transition:enter-start="opacity-0 -translate-y-2"
                                    x-transition:enter-end="opacity-100 translate-y-0"
                                    class="pl-12 mt-1 space-y-1">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase plan')): ?>
                                    <a href="<?php echo e(route('user.investment.buyplan')); ?>" 
                                        <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                        class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                            'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                            'text-theme-primary' => request()->routeIs('user.investment.buyplan'),
                                            'text-gray-400 hover:text-gray-100' => !request()->routeIs('user.investment.buyplan')
                                        ]); ?>">
                                        Browse Plans
                                    </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('see their plans')): ?>
                                    <a href="<?php echo e(route('user.investment.myplans')); ?>" 
                                        <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                        class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                            'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                            'text-theme-primary' => request()->routeIs('user.investment.myplans'),
                                            'text-gray-400 hover:text-gray-100' => !request()->routeIs('user.investment.myplans')
                                        ]); ?>">
                                        My Investments
                                    </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>

                        
                        <div class="mb-6">
                            <p class="px-4 py-2 text-xs font-medium text-gray-400 uppercase mb-2">Wallet</p>
                            
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('make deposit')): ?>
                            <a href="<?php echo e(route('user.deposit.make')); ?>" 
                                <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                                    'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.deposit.*'),
                                    'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.deposit.*')
                                ]); ?>">
                                <i class="fas fa-wallet w-5 h-5"></i>
                                <span>Deposit Funds</span>
                            </a>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('make withdrawal')): ?>
                            <a href="<?php echo e(route('user.withdraw.request')); ?>" 
                                <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                                    'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.withdraw.request'),
                                    'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.withdraw.request')
                                ]); ?>">
                                <i class="fas fa-money-bill-transfer w-5 h-5"></i>
                                <span>Withdraw Funds</span>
                            </a>
                            <?php endif; ?>

                            <?php if($settings->use_transfer): ?>
                            <a href="<?php echo e(route('user.transferfund')); ?>" 
                                <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                                    'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.transferfund'),
                                    'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.transferfund')
                                ]); ?>">
                                <i class="fas fa-exchange-alt w-5 h-5"></i>
                                <span>Transfer Funds</span>
                            </a>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('see their transactions history')): ?>
                            <a href="<?php echo e(route('user.transactions.deposit')); ?>" 
                                <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                                    'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.transactions.*'),
                                    'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.transactions.*')
                                ]); ?>">
                                <i class="fas fa-receipt w-5 h-5"></i>
                                <span>Transaction History</span>
                            </a>
                            <?php endif; ?>
                        </div>

                        
                        <?php if($mod['membership'] == 'true'): ?>
                        <div class="mb-6">
                            <p class="px-4 py-2 text-xs font-medium text-gray-400 uppercase mb-2">Education</p>
                            
                            <div x-data="{ open: <?php echo e(request()->routeIs('user.membership.*') ? 'true' : 'false'); ?> }">
                                <button @click="open = !open" 
                                    class="flex items-center justify-between w-full px-4 py-2.5 rounded-xl transition-all"
                                    :class="{'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary': open, 'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100': !open}">
                                    <div class="flex items-center gap-3">
                                        <i class="fas fa-graduation-cap w-5 h-5"></i>
                                        <span>Learning Center</span>
                                    </div>
                                    <i class="fas fa-chevron-down w-4 h-4 transition-transform" :class="open ? 'rotate-180' : ''"></i>
                                </button>
                                <div x-show="open"
                                    x-transition:enter="transition ease-out duration-200"
                                    x-transition:enter-start="opacity-0 -translate-y-2"
                                    x-transition:enter-end="opacity-100 translate-y-0"
                                    class="pl-12 mt-1 space-y-1">
                                    <a href="<?php echo e(route('user.membership.courses', ['page' => '1'])); ?>" 
                                        <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                        class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                            'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                            'text-theme-primary' => request()->routeIs('user.membership.courses'),
                                            'text-gray-400 hover:text-gray-100' => !request()->routeIs('user.membership.courses')
                                        ]); ?>">
                                        All Courses
                                    </a>
                                    <a href="<?php echo e(route('user.membership.mycourses')); ?>" 
                                        <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                        class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                            'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                            'text-theme-primary' => request()->routeIs('user.membership.mycourses'),
                                            'text-gray-400 hover:text-gray-100' => !request()->routeIs('user.membership.mycourses')
                                        ]); ?>">
                                        My Courses
                                    </a>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>

                        
                        <div class="mb-6">
                            <p class="px-4 py-2 text-xs font-medium text-gray-400 uppercase mb-2">Account</p>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('refer users')): ?>
                            <a href="<?php echo e(route('user.referral')); ?>" 
                                <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                                    'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.referral'),
                                    'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.referral')
                                ]); ?>">
                                <i class="fas fa-users w-5 h-5"></i>
                                <span>Referral Program</span>
                            </a>
                            <?php endif; ?>

                            <a href="<?php echo e(route('user.notifications')); ?>" 
                                <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                                    'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.notifications'),
                                    'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.notifications')
                                ]); ?>">
                                <i class="fas fa-bell w-5 h-5"></i>
                                <span>Notifications</span>
                            </a>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact support')): ?>
                            <a href="<?php echo e(route('user.contactsupport')); ?>" 
                                <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                                    'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.contactsupport'),
                                    'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.contactsupport')
                                ]); ?>">
                                <i class="fas fa-headset w-5 h-5"></i>
                                <span>Support Center</span>
                            </a>
                            <?php endif; ?>
                        </div>
                    </nav>
                </div>
            </div>

            
            <div class="p-4 border-t border-gray-800/50">
                
                <div class="bg-gradient-to-br from-theme-primary/20 to-transparent p-4 rounded-xl mb-4">
                    <h4 class="font-medium text-theme-primary mb-2">Start Trading Today</h4>
                    <p class="text-sm text-gray-400 mb-3">Access global markets and grow your portfolio</p>
                    <a href="<?php echo e(route('user.trading.overview')); ?>" 
                        <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                        class="block w-full bg-gradient-to-r from-theme-primary to-theme-primary/80 text-white text-sm font-medium py-2.5 px-4 rounded-lg hover:brightness-110 transition-all text-center">
                        Trade Now
                    </a>
                </div>

                
                <form action="<?php echo e(route('logout')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" 
                        class="w-full flex items-center justify-center gap-2 px-4 py-2.5 rounded-xl text-gray-400 hover:bg-theme-tertiary hover:text-gray-100 transition-all">
                        <i class="fas fa-sign-out-alt w-5 h-5"></i>
                        <span><?php echo e(__('t.logout')); ?></span>
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    // Mobile Sidebar Toggle
    document.addEventListener('DOMContentLoaded', function() {
        const mobileSidebar = document.getElementById('mobileSidebar');
        const closeMobileSidebar = document.getElementById('closeMobileSidebar');
        
        // Close button click
        closeMobileSidebar.addEventListener('click', function() {
            mobileSidebar.classList.add('hidden');
        });

        // Close on outside click
        mobileSidebar.addEventListener('click', function(e) {
            if (e.target === mobileSidebar) {
                mobileSidebar.classList.add('hidden');
            }
        });
    });
</script>





<?php /**PATH C:\xampp\htdocs\6figs\resources\views/layouts/includes/mobile-sidebar.blade.php ENDPATH**/ ?>