<aside class="hidden md:flex flex-col w-72 bg-white dark:bg-[#0F0A1F] border-r border-gray-100/50 dark:border-gray-800/50 min-h-screen overflow-y-auto">
    {{-- User Profile Section --}}
    <div class="p-6 border-b border-gray-100/50 dark:border-gray-800/50">
        <div class="flex items-center gap-4">
            <div class="w-12 h-12 rounded-xl bg-gray-100 dark:bg-[#1A1428] flex-shrink-0 overflow-hidden">
                <img 
                    src="{{ auth()->user()->profile_photo_path ? asset('storage/' . auth()->user()->profile_photo_path) : asset('dash/images/avatar.svg') }}"
                    alt="{{ auth()->user()->name }}"
                    class="w-full h-full object-cover">
            </div>
            <div class="flex-1 min-w-0">
                <h3 class="font-medium text-gray-900 dark:text-white truncate">{{ auth()->user()->name }}</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 truncate">{{ auth()->user()->email }}</p>
            </div>
        </div>
    </div>

    {{-- Navigation Menu --}}
    <div class="p-4 flex-1">
        <nav class="space-y-1">
            {{-- Main Navigation Group --}}
            <div class="space-y-1 mb-6">
                {{-- Dashboard --}}
                <a href="{{ route('user.dashboard') }}" 
                    @if($settings->spa_mode) wire:navigate @endif
                    @class([
                        'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                        'bg-gradient-to-r from-cyan-500/10 dark:from-[#2FE6DE]/10 to-transparent text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.dashboard'),
                        'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#1A1428] hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.dashboard')
                    ])>
                    <i class="fas fa-th-large w-5 h-5"></i>
                    <span>Dashboard</span>
                </a>

                {{-- Funds Management Group --}}
                <div class="mt-6">
                    <p class="px-4 py-2 text-xs font-medium text-gray-600 dark:text-gray-400 uppercase mb-2">Funds Management</p>
                    
                    @can('make deposit')
                    <a href="{{ route('user.deposit.make') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-cyan-500/10 dark:from-[#2FE6DE]/10 to-transparent text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.deposit.*'),
                            'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#1A1428] hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.deposit.*')
                        ])>
                        <i class="fas fa-arrow-down w-5 h-5"></i>
                        <span>Deposit</span>
                    </a>
                    @endcan
                    @can('make withdrawal')
                    <a href="{{ route('user.withdraw.request') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-cyan-500/10 dark:from-[#2FE6DE]/10 to-transparent text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.withdraw.request'),
                            'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#1A1428] hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.withdraw.request')
                        ])>
                        <i class="fas fa-arrow-up w-5 h-5"></i>
                        <span>Withdraw</span>
                    </a>
                    @endcan

                    @can('see their transactions history')
                    <a href="{{ route('user.transactions.deposit') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-cyan-500/10 dark:from-[#2FE6DE]/10 to-transparent text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.transactions.*'),
                            'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#1A1428] hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.transactions.*')
                        ])>
                        <i class="fas fa-receipt w-5 h-5"></i>
                        <span>Transactions</span>
                    </a>
                    @endcan

                    @if($settings->use_transfer)
                    <a href="{{ route('user.transferfund') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-cyan-500/10 dark:from-[#2FE6DE]/10 to-transparent text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.transferfund'),
                            'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#1A1428] hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.transferfund')
                        ])>
                        <i class="fas fa-exchange-alt w-5 h-5"></i>
                        <span>Transfer Funds</span>
                    </a>
                    @endif
                </div>

                {{-- Trading & Investment Group --}}
                <div class="mt-6">
                    <p class="px-4 py-2 text-xs font-medium text-gray-600 dark:text-gray-400 uppercase mb-2">Trading & Investment</p>

                    @if($mod['investment'] == 'true')
                    <div x-data="{ open: {{ request()->routeIs('user.investment.*') ? 'true' : 'false' }} }">
                        <button @click="open = !open" 
                            class="flex items-center justify-between w-full px-4 py-2.5 rounded-xl transition-all"
                            :class="{'bg-gradient-to-r from-cyan-500/10 dark:from-[#2FE6DE]/10 to-transparent text-cyan-500 dark:text-[#2FE6DE]': open, 'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#1A1428] hover:text-gray-900 dark:hover:text-gray-100': !open}">
                            <div class="flex items-center gap-3">
                                <i class="fas fa-chart-line w-5 h-5"></i>
                                <span>Investment Plans</span>
                            </div>
                            <i class="fas fa-chevron-down w-4 h-4 transition-transform" :class="open ? 'rotate-180' : ''"></i>
                        </button>
                        <div x-show="open" 
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 -translate-y-2"
                            x-transition:enter-end="opacity-100 translate-y-0"
                            class="pl-12 mt-1 space-y-1">
                            @can('purchase plan')
                            <a href="{{ route('user.investment.buyplan') }}" 
                                @if($settings->spa_mode) wire:navigate @endif
                                @class([
                                    'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                    'text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.investment.buyplan'),
                                    'text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.investment.buyplan')
                                ])>
                                Buy a Plan
                            </a>
                            @endcan
                            @can('see their plans')
                            <a href="{{ route('user.investment.myplans') }}" 
                                @if($settings->spa_mode) wire:navigate @endif
                                @class([
                                    'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                    'text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.investment.myplans'),
                                    'text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.investment.myplans')
                                ])>
                                My Plans
                            </a>
                            @endcan
                        </div>
                    </div>
                    @endif

                    {{-- Crypto Swap --}}
                    @if($mod['cryptoswap'] == 'true')
                    <div x-data="{ open: {{ request()->routeIs('user.swap.*') ? 'true' : 'false' }} }">
                        <button @click="open = !open" 
                            class="flex items-center justify-between w-full px-4 py-2.5 rounded-xl transition-all"
                            :class="{'bg-gradient-to-r from-cyan-500/10 dark:from-[#2FE6DE]/10 to-transparent text-cyan-500 dark:text-[#2FE6DE]': open, 'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#1A1428] hover:text-gray-900 dark:hover:text-gray-100': !open}">
                            <div class="flex items-center gap-3">
                                <i data-lucide="repeat" class="w-5 h-5"></i>
                                <span>Swap Crypto</span>
                            </div>
                            <i class="fas fa-chevron-down w-4 h-4 transition-transform" :class="open ? 'rotate-180' : ''"></i>
                        </button>
                        <div x-show="open" class="pl-12 mt-1 space-y-1" x-collapse>
                            <a href="{{ route('user.swap.assets') }}" 
                                @if($settings->spa_mode) wire:navigate @endif
                                @class([
                                    'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                    'text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.swap.assets'),
                                    'text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.swap.assets')
                                ])>
                                Assets
                            </a>
                            <a href="{{ route('user.swap.transactions') }}" 
                                @if($settings->spa_mode) wire:navigate @endif
                                @class([
                                    'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                    'text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.swap.transactions'),
                                    'text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.swap.transactions')
                                ])>
                                Swap History
                            </a>
                        </div>
                    </div>
                    @endif
                    {{-- Copy Trading --}}
                    @if($mod['subscription'] == 'true')
                    <a href="{{ route('user.copier.show') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all',
                            'bg-gradient-to-r from-cyan-500/10 dark:from-[#2FE6DE]/10 to-transparent text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.copier.*'),
                            'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#1A1428] hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.copier.*')
                        ])>
                        <i data-lucide="copy" class="w-5 h-5"></i>
                        <span>Copy Trading</span>
                    </a>
                    @endif

                    {{-- Trade Signals --}}
                    @if($mod['signal'] == 'true')
                    <a href="{{ route('user.tradeSignals', ['page' => '1']) }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all',
                            'bg-gradient-to-r from-cyan-500/10 dark:from-[#2FE6DE]/10 to-transparent text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.tradeSignals'),
                            'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#1A1428] hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.tradeSignals')
                        ])>
                        <i data-lucide="radio" class="w-5 h-5"></i>
                        <span>Trade Signals</span>
                    </a>
                    @endif

                    {{-- Education/Membership --}}
                    @if($mod['membership'] == 'true')
                    <div x-data="{ open: {{ request()->routeIs('user.membership.*') ? 'true' : 'false' }} }">
                        <button @click="open = !open" 
                            class="flex items-center justify-between w-full px-4 py-2.5 rounded-xl transition-all"
                            :class="{'bg-gradient-to-r from-cyan-500/10 dark:from-[#2FE6DE]/10 to-transparent text-cyan-500 dark:text-[#2FE6DE]': open, 'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#1A1428] hover:text-gray-900 dark:hover:text-gray-100': !open}">
                            <div class="flex items-center gap-3">
                                <i data-lucide="graduation-cap" class="w-5 h-5"></i>
                                <span>Education</span>
                            </div>
                            <i class="fas fa-chevron-down w-4 h-4 transition-transform" :class="open ? 'rotate-180' : ''"></i>
                        </button>
                        <div x-show="open" class="pl-12 mt-1 space-y-1" x-collapse>
                            <a href="{{ route('user.membership.courses', ['page' => '1']) }}" 
                                @if($settings->spa_mode) wire:navigate @endif
                                @class([
                                    'flex items-center gap-3 px-4 py-2 rounded-xl transition-all',
                                    'text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.membership.courses'),
                                    'text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.membership.courses')
                                ])>
                                Courses
                            </a>
                            <a href="{{ route('user.membership.mycourses') }}" 
                                @if($settings->spa_mode) wire:navigate @endif
                                @class([
                                    'flex items-center gap-3 px-4 py-2 rounded-xl transition-all',
                                    'text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.membership.mycourses'),
                                    'text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.membership.mycourses')
                                ])>
                                My Courses
                            </a>
                        </div>
                    </div>
                    @endif
                </div>
                {{-- Account Settings --}}
                <div class="mt-6">
                    <p class="px-4 py-2 text-xs font-medium text-gray-600 dark:text-gray-400 uppercase mb-2">Account</p>

                    @can('refer users')
                    <a href="{{ route('user.referral') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-cyan-500/10 dark:from-[#2FE6DE]/10 to-transparent text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.referral'),
                            'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#1A1428] hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.referral')
                        ])>
                        <i class="fas fa-users w-5 h-5"></i>
                        <span>Referrals</span>
                    </a>
                    @endcan

                    <a href="{{ route('user.notifications') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-cyan-500/10 dark:from-[#2FE6DE]/10 to-transparent text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.notifications'),
                            'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#1A1428] hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.notifications')
                        ])>
                        <i class="fas fa-bell w-5 h-5"></i>
                        <span>Notifications</span>
                    </a>

                    @can('contact support')
                    <a href="{{ route('user.contactsupport') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-cyan-500/10 dark:from-[#2FE6DE]/10 to-transparent text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.contactsupport'),
                            'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#1A1428] hover:text-gray-900 dark:hover:text-gray-100' => !request()->routeIs('user.contactsupport')
                        ])>
                        <i class="fas fa-headset w-5 h-5"></i>
                        <span>Support</span>
                    </a>
                    @endcan
                </div>
            </div>
        </nav>
        {{-- Promotional Card & Logout --}}
    <div class="p-4 border-t border-gray-100/50 dark:border-gray-800/50">
        {{-- Promo Card --}}
        <div class="bg-gradient-to-br from-cyan-500/20 dark:from-[#2FE6DE]/20 to-transparent p-4 rounded-xl mb-4">
            <h4 class="font-medium text-cyan-500 dark:text-[#2FE6DE] mb-2">Ready to Grow?</h4>
            <p class="text-sm text-gray-600 dark:text-gray-400 mb-3">Start your trading journey today and watch your portfolio expand.</p>
            <a href="{{ route('user.investment.buyplan') }}" 
                @if($settings->spa_mode) wire:navigate @endif
                class="block w-full bg-gradient-to-r from-cyan-500 dark:from-[#2FE6DE] to-cyan-500/80 dark:to-[#2FE6DE]/80 text-white dark:text-black text-sm font-medium py-2 px-4 rounded-lg hover:brightness-110 transition-all text-center">
                Start Trading
            </a>
        </div>

        {{-- Logout Button --}}
        <form action="{{ route('logout') }}" method="POST">
            @csrf
            <button type="submit" 
                class="w-full flex items-center justify-center gap-2 px-4 py-2.5 rounded-xl text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#1A1428] hover:text-gray-900 dark:hover:text-gray-100 transition-all">
                <i class="fas fa-sign-out-alt w-5 h-5"></i>
                <span>Logout</span>
            </button>
        </form>
    </div>
    </div>

    
</aside>